/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpEngine;

import ibm.nways.analysis.dpCommon.DataPoint;
import ibm.nways.analysis.dpCommon.GenericDataPoint;
import ibm.nways.analysis.dpCommon.MultiDataPoint;
import ibm.nways.analysis.dpCommon.NotifyObject;
import ibm.nways.analysis.dpCommon.PerformanceEvent;
import ibm.nways.analysis.dpCommon.PollingObjectDefinition;
import ibm.nways.analysis.dpCommon.PollingObjectInstance;
import ibm.nways.analysis.dpEngine.Daily;
import ibm.nways.analysis.dpEngine.DpInterfaceImpl;
import ibm.nways.analysis.dpEngine.DpNode;
import ibm.nways.analysis.dpEngine.DpPollingInstance;
import ibm.nways.analysis.dpEngine.Expression;
import ibm.nways.analysis.dpEngine.IllegalInsertException;
import ibm.nways.analysis.dpEngine.NeedInsertException;
import ibm.nways.analysis.dpEngine.NodeList;
import ibm.nways.analysis.dpEngine.OiList;
import ibm.nways.analysis.dpEngine.Weekly;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.common.TimeTicks;
import ibm.nways.jdm.snmp.PollingAction;
import ibm.nways.jdm.snmp.PollingFilter;
import ibm.nways.jdm.snmp.PollingInterval;
import ibm.nways.jdm.snmp.PollingPreFilter;
import ibm.nways.jdm.snmp.SnmpPoller;
import ibm.nways.jdm.snmp.TableHandler;
import ibm.nways.jdm.snmp.TablePoller;
import ibm.nways.jdm.snmp.TablePollingAction;
import ibm.nways.jdm.snmp.TablePollingFilter;
import ibm.nways.jdm.snmp.TablePollingPreFilter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

class DpPollingDefinition
implements PollingAction,
PollingFilter,
PollingPreFilter,
TableHandler,
TablePollingAction,
TablePollingFilter,
TablePollingPreFilter {
    private PollingObjectDefinition definition;
    private Hashtable pollingInstances;
    protected Expression[] expressionList;
    protected SnmpPoller scalarPoller;
    protected TablePoller tablePoller;
    private NotifyObject armStuff;
    private Float[] results;
    protected OiList oiList;

    public DpPollingDefinition(PollingObjectDefinition pollingObjectDefinition) throws IllegalInsertException {
        this.definition = pollingObjectDefinition;
        this.pollingInstances = new Hashtable();
        this.armStuff = pollingObjectDefinition.getNotifyObject();
        if (this.armStuff == null) {
            DpInterfaceImpl.LogMessage("CREATING DEFINITION WITH NO NO");
        }
        String string = pollingObjectDefinition.getExpression();
        try {
            this.oiList = new OiList(string);
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            this.expressionList = new Expression[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.expressionList[n++] = new Expression(stringTokenizer.nextToken(), this.oiList, null);
            }
            this.oiList.setWildcardVsScalar();
            PollingInterval pollingInterval = new PollingInterval(pollingObjectDefinition.getNotifyObject().getPollingInterval() * 1000);
            DpInterfaceImpl.modifyHeartbeatTimeout(pollingObjectDefinition.getNotifyObject().getPollingInterval() * 1000);
            if (this.oiList.getScalarOIcount() != 0 && !OiList.containsRelativeIndex(string)) {
                this.scalarPoller = new SnmpPoller(pollingInterval, this.oiList.getScalarOIs(), true, (PollingAction)this, (PollingFilter)this, (PollingPreFilter)this);
            }
            if (this.oiList.getWildcardOIcount() != 0) {
                this.tablePoller = new TablePoller(pollingInterval, this.oiList.getWildcardOIs(), null, true, (TableHandler)this, (TablePollingAction)this, (TablePollingFilter)this, (TablePollingPreFilter)this);
                return;
            }
        }
        catch (NeedInsertException needInsertException) {
            this.oiList = null;
            this.expressionList = null;
            this.scalarPoller = null;
            this.tablePoller = null;
            if (DpInterfaceImpl.trace) {
                DpInterfaceImpl.LogMessage("POD:adding POD failed due to Insert");
                return;
            }
        }
        catch (Exception exception) {
            this.oiList = null;
            this.expressionList = null;
            this.scalarPoller = null;
            this.tablePoller = null;
            DpInterfaceImpl.LogMessage("POD:adding POD failed : " + exception.toString());
        }
    }

    protected boolean hasInstances() {
        return !this.pollingInstances.isEmpty();
    }

    public PollingObjectDefinition getPollingObjectDefinition() {
        return this.definition;
    }

    public OiList getOiList() {
        return this.oiList;
    }

    protected Expression[] getExpressionList() {
        return this.expressionList;
    }

    public void kill() {
        Enumeration enumeration = this.pollingInstances.elements();
        while (enumeration.hasMoreElements()) {
            DpPollingInstance dpPollingInstance = (DpPollingInstance)enumeration.nextElement();
            dpPollingInstance.removeAllNodes();
        }
        this.pollingInstances.clear();
    }

    protected boolean modifyDefinition(NotifyObject notifyObject) {
        boolean bl = true;
        Enumeration enumeration = this.pollingInstances.elements();
        while (enumeration.hasMoreElements()) {
            DpPollingInstance dpPollingInstance = (DpPollingInstance)enumeration.nextElement();
            if (dpPollingInstance.changeNotifyObjects(notifyObject)) continue;
            bl = false;
        }
        this.armStuff = notifyObject;
        return bl;
    }

    protected boolean addPollingInstance(long l, String string, String string2, NodeList nodeList, Hashtable hashtable, boolean bl) {
        boolean bl2;
        block14: {
            bl2 = true;
            DpPollingInstance dpPollingInstance = (DpPollingInstance)this.pollingInstances.get(string);
            if (dpPollingInstance == null || !dpPollingInstance.idExists(l)) {
                if (DpInterfaceImpl.trace) {
                    DpInterfaceImpl.LogMessage("   POD: --> addPollingInstance" + l + " host:" + string);
                }
                try {
                    if (dpPollingInstance == null) {
                        dpPollingInstance = new DpPollingInstance(this, string, string2, nodeList, hashtable, bl);
                    }
                    if (this.armStuff != null) {
                        if (this.expressionList != null) {
                            if (dpPollingInstance.addNotifyObject(l, null, this.scalarPoller, this.tablePoller, bl)) {
                                this.pollingInstances.put(string, dpPollingInstance);
                            } else {
                                DpInterfaceImpl.LogMessage("POD : Adding NotifyObject failed in addPOI");
                            }
                        } else if (dpPollingInstance.addNode(l, this.armStuff, hashtable, bl)) {
                            this.pollingInstances.put(string, dpPollingInstance);
                        } else {
                            DpInterfaceImpl.LogMessage("POD : Adding NotifyObject for Definition with inserts failed in addPOI");
                        }
                        break block14;
                    }
                    DpInterfaceImpl.LogMessage("  POD: Attempt to create POI with null NO");
                    bl2 = false;
                }
                catch (Exception exception) {
                    DpInterfaceImpl.LogMessage("  POD: Attempt to create POI caused Exception : " + exception.toString());
                    exception.printStackTrace();
                    bl2 = false;
                }
            } else {
                if (DpInterfaceImpl.trace) {
                    DpInterfaceImpl.LogMessage("POD : POI not added to POD - already exists -- POI=" + string);
                }
                bl2 = false;
            }
        }
        return bl2;
    }

    protected boolean removePollingInstance(String string, long l, NodeList nodeList) {
        boolean bl = true;
        DpPollingInstance dpPollingInstance = (DpPollingInstance)this.pollingInstances.get(string);
        if (dpPollingInstance != null) {
            dpPollingInstance.removeSpecificNode(l);
            if (!dpPollingInstance.hasNodes()) {
                dpPollingInstance = (DpPollingInstance)this.pollingInstances.remove(string);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    protected void activatePollers() {
        Enumeration enumeration = this.pollingInstances.elements();
        while (enumeration.hasMoreElements()) {
            DpPollingInstance dpPollingInstance = (DpPollingInstance)enumeration.nextElement();
            dpPollingInstance.activatePollers();
        }
    }

    protected void suspendPollers() {
        Enumeration enumeration = this.pollingInstances.elements();
        while (enumeration.hasMoreElements()) {
            DpPollingInstance dpPollingInstance = (DpPollingInstance)enumeration.nextElement();
            dpPollingInstance.suspendPollers();
        }
    }

    protected void changeInterval(Object object) {
        if (DpInterfaceImpl.trace_schedule) {
            DpInterfaceImpl.LogMessage("POD: changeInterval(" + object.toString() + ")");
        }
        Enumeration enumeration = this.pollingInstances.elements();
        while (enumeration.hasMoreElements()) {
            DpPollingInstance dpPollingInstance = (DpPollingInstance)enumeration.nextElement();
            dpPollingInstance.changeState((String)object);
        }
    }

    protected void changeHistorySize(int n) {
        Enumeration enumeration = this.pollingInstances.elements();
        while (enumeration.hasMoreElements()) {
            DpPollingInstance dpPollingInstance = (DpPollingInstance)enumeration.nextElement();
            dpPollingInstance.changeHistorySize(n);
        }
    }

    protected DpPollingInstance getSpecificPollingInstance(String string, long l) {
        DpPollingInstance dpPollingInstance = (DpPollingInstance)this.pollingInstances.get(string);
        if (dpPollingInstance.getSpecificNode(l) != null) {
            return dpPollingInstance;
        }
        return null;
    }

    protected boolean modifySpecificPollingInstance(int n, String string, long l, NotifyObject notifyObject) {
        boolean bl;
        DpPollingInstance dpPollingInstance;
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("modifying Polling instance - " + n);
        }
        if ((dpPollingInstance = (DpPollingInstance)this.pollingInstances.get(string)) != null) {
            switch (n) {
                case 1: {
                    dpPollingInstance.addNotifyObject(l, notifyObject, false);
                    bl = true;
                    break;
                }
                case 0: {
                    dpPollingInstance.addNotifyObject(l, notifyObject, false);
                    bl = true;
                    break;
                }
                case 2: {
                    dpPollingInstance.removeNotifyObject(l, notifyObject);
                    dpPollingInstance.addNotifyObject(l, notifyObject, false);
                    bl = true;
                    break;
                }
                default: {
                    DpInterfaceImpl.LogMessage("invalid operation in modifySpecificPollingInstance");
                    bl = false;
                    break;
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    protected boolean scheduleSpecificPollingInstance(PollingObjectInstance pollingObjectInstance, Daily daily, int n) {
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("DpPollingDefintion:scheduling Polling instance - " + pollingObjectInstance.toString());
        }
        boolean bl = true;
        DpPollingInstance dpPollingInstance = (DpPollingInstance)this.pollingInstances.get(pollingObjectInstance.getHostname());
        bl = dpPollingInstance != null ? dpPollingInstance.scheduleInstance(daily, n) : false;
        return bl;
    }

    protected boolean scheduleSpecificPollingInstance(PollingObjectInstance pollingObjectInstance, Weekly weekly, int n) {
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("DpPollingDefintion:scheduling Polling instance - " + pollingObjectInstance.toString());
        }
        boolean bl = true;
        DpPollingInstance dpPollingInstance = (DpPollingInstance)this.pollingInstances.get(pollingObjectInstance.getHostname());
        bl = dpPollingInstance != null ? dpPollingInstance.scheduleInstance(weekly, n) : false;
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DpPollingDefinition:\n");
        stringBuffer.append(this.definition.toString());
        stringBuffer.append(" Polling Instances : \n");
        Enumeration enumeration = this.pollingInstances.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(((DpPollingInstance)enumeration.nextElement()).toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public Object rowAdded(Object object, String string) {
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("Adding row:" + string);
        }
        DpNode dpNode = (DpNode)object;
        return dpNode.addRow(string);
    }

    public Object rowAdded(Object object, OID oID) {
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("Adding row:" + oID);
        }
        DpNode dpNode = (DpNode)object;
        return dpNode.addRow(oID);
    }

    public void rowDeleted(Object object, Object object2) {
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("Deleting row:");
        }
        DpNode dpNode = (DpNode)object;
        dpNode.removeRow(object2);
    }

    public void handle(Object object, Vector vector, Vector vector2, Vector vector3, long l) {
        DpNode dpNode = (DpNode)object;
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("- POP multi-value +  " + this.definition.getIdentifier() + ":" + dpNode.getNodeName());
        }
        if (dpNode.getNotifyObject().getWhenToNotify() == 5) {
            DpInterfaceImpl.LogMessage("POD:Throwing away table changeMonitor event");
            return;
        }
        int n = dpNode.getNotifyObject().getWhenToNotify() == 1 ? 4 : 1;
        if (dpNode.expressionList.length == 1) {
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                if (dpNode.validResult(vector.elementAt(n3))) {
                    if (n != 4) {
                        n = dpNode.getArmedState(vector.elementAt(n3)) ? 1 : 2;
                    }
                    DataPoint dataPoint = new DataPoint(l, dpNode.getRowId(vector.elementAt(n3)), dpNode.getResult(vector.elementAt(n3), 0));
                    Vector<DataPoint> vector4 = new Vector<DataPoint>();
                    vector4.addElement(dataPoint);
                    PerformanceEvent performanceEvent = new PerformanceEvent(n, dpNode.getNodeName(), dpNode.getPollingDefinition().getPollingObjectDefinition().getIdentifier(), vector4, dpNode.getId(), l);
                    DpInterfaceImpl.addNotification(performanceEvent);
                }
                ++n3;
            }
        } else {
            int n4 = vector.size();
            int n5 = 0;
            while (n5 < n4) {
                if (dpNode.validResult(vector.elementAt(n5))) {
                    MultiDataPoint multiDataPoint = new MultiDataPoint(l, dpNode.getRowId(vector.elementAt(n5)), null);
                    multiDataPoint.setValues(dpNode.getResults(vector.elementAt(n5)));
                    Vector<MultiDataPoint> vector5 = new Vector<MultiDataPoint>();
                    vector5.addElement(multiDataPoint);
                    PerformanceEvent performanceEvent = new PerformanceEvent(n, dpNode.getNodeName(), dpNode.getPollingDefinition().getPollingObjectDefinition().getIdentifier(), vector5, dpNode.getId(), l);
                    DpInterfaceImpl.LogMessage("POD:Throwing away multi-valued table performance event:\n" + performanceEvent.toString());
                }
                ++n5;
            }
        }
        dpNode.clearResults(vector);
    }

    public boolean evaluate(Object object, Vector vector, Vector vector2, Vector vector3, long l) {
        DpNode dpNode = (DpNode)object;
        boolean bl = false;
        int n = vector.size();
        if (dpNode.getNotifyObject().getWhenToNotify() != 5) {
            if (dpNode.getPollingInstance().sendEvents()) {
                int n2 = 0;
                while (n2 < n) {
                    if (this.eval(dpNode, vector.elementAt(n2))) {
                        bl = true;
                    } else {
                        dpNode.clearResult(vector.elementAt(n2), 0);
                    }
                    ++n2;
                }
            } else {
                int n3 = 0;
                while (n3 < n) {
                    dpNode.clearResult(vector.elementAt(n3), 0);
                    ++n3;
                }
            }
        } else {
            int n4 = 0;
            while (n4 < n && !bl) {
                Object[] objectArray = (Object[])vector2.elementAt(n4);
                Object[] objectArray2 = (Object[])vector3.elementAt(n4);
                int n5 = 0;
                while (n5 < objectArray.length && !bl) {
                    if (!objectArray[n5].equals(objectArray2[n5])) {
                        bl = true;
                    }
                    ++n5;
                }
                ++n4;
            }
        }
        return bl;
    }

    public void preHandle(Object object, Vector vector, Vector vector2, Vector vector3, long l) {
        Object object2;
        int n = 0;
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("Table pre-handle called");
            object2 = vector2.elements();
            Enumeration enumeration = vector3.elements();
            while (object2.hasMoreElements()) {
                DpInterfaceImpl.LogMessage("looking at a row:");
                Object[] objectArray = (Object[])object2.nextElement();
                Object[] objectArray2 = (Object[])enumeration.nextElement();
                int n2 = 0;
                while (n2 < objectArray.length) {
                    DpInterfaceImpl.LogMessage("oldvalue:" + objectArray2[n2] + ", value:" + objectArray[n2]);
                    ++n2;
                }
            }
        }
        if (((DpNode)(object2 = (DpNode)object)).getNotifyObject().getWhenToNotify() == 5) {
            return;
        }
        if (object2 != null) {
            long l2;
            long l3;
            if (DpInterfaceImpl.useSysUpTime) {
                l3 = ((TimeTicks)((DpNode)object2).getNewValues()[((DpNode)object2).getSysUpTimeIndex()]).getValue();
                l2 = ((Object[])vector3.elementAt(0))[0] == null ? 0L : ((TimeTicks)((DpNode)object2).getOldValues()[((DpNode)object2).getSysUpTimeIndex()]).getValue();
                l3 /= 100L;
                l2 /= 100L;
            } else {
                l2 = ((DpNode)object2).getLatestEntry().getDate();
                l3 = l;
                l3 /= 1000L;
                l2 /= 1000L;
            }
            int n3 = vector.size();
            int n4 = 0;
            try {
                int n5 = 0;
                while (n5 < n3) {
                    ((DpNode)object2).setTableValues(n5, (Object[])vector3.elementAt(n5), (Object[])vector2.elementAt(n5));
                    n += ((Object[])vector2.elementAt(n5)).length;
                    n4 = ((DpNode)object2).expressionList.length;
                    int n6 = 0;
                    while (n6 < n4) {
                        ((DpNode)object2).setResult(n6, vector.elementAt(n5), ((DpNode)object2).expressionList[n6].calculate(((DpNode)object2).getNewValues(), ((DpNode)object2).getOldValues(), l3, l2));
                        ++n6;
                    }
                    ++n5;
                }
            }
            catch (Exception exception) {
                DpInterfaceImpl.LogMessage("error looping through rows." + exception);
                DpInterfaceImpl.LogMessage("size=" + n3 + ", size()=" + vector.size());
                DpInterfaceImpl.LogMessage("limit=" + n4);
                DpInterfaceImpl.LogMessage("oldV.size()=" + vector3.size() + ", newvals.size()=" + vector2.size());
                DpInterfaceImpl.LogMessage("sysUpTimeIndex = " + ((DpNode)object2).getSysUpTimeIndex());
                exception.printStackTrace();
            }
            if (l2 != 0L) {
                long l4 = l3 - l2;
                long l5 = ((DpNode)object2).getNotifyObject().getPollingInterval();
                if (l4 < l5 + 1L) {
                    DpInterfaceImpl.intervalMatched((DpNode)object2);
                } else {
                    DpInterfaceImpl.intervalExceeded((DpNode)object2, l, l2, l5);
                }
            }
            if (((DpNode)object2).getNotifyObject().getWhenToNotify() != 5) {
                ((DpNode)object2).addToHistory(l, vector);
            }
            if (DpInterfaceImpl.trace) {
                DpInterfaceImpl.LogMessage("Adding data");
            }
            DpInterfaceImpl.interfaceObject.updateCounters(1, n);
            return;
        }
        DpInterfaceImpl.LogMessage("preHandle called with no userData");
    }

    public void timeoutOccurred(Object object) {
        DpNode dpNode = (DpNode)object;
        DpInterfaceImpl.intervalExceeded(dpNode, System.currentTimeMillis(), 0L, 0L);
    }

    public void handle(Object object, Object[] objectArray, Object[] objectArray2, long l) {
        DpNode dpNode = (DpNode)object;
        if (DpInterfaceImpl.trace) {
            DpInterfaceImpl.LogMessage("- POP +  " + this.definition.getIdentifier() + ":" + dpNode.getNodeName());
        }
        if (dpNode.getNotifyObject().getWhenToNotify() == 5) {
            DpInterfaceImpl.LogMessage("POD: tossing changeMonitor event");
            return;
        }
        if (dpNode.scalarPoller != null && dpNode.tablePoller == null) {
            int n = dpNode.getNotifyObject().getWhenToNotify() == 1 ? 4 : (dpNode.isarmed() ? 1 : 2);
            Vector<GenericDataPoint> vector = new Vector<GenericDataPoint>();
            vector.addElement(dpNode.getLatestEntry());
            PerformanceEvent performanceEvent = new PerformanceEvent(n, dpNode.getNodeName(), dpNode.getPollingDefinition().getPollingObjectDefinition().getIdentifier(), vector, dpNode.getId(), l);
            if (dpNode.expressionList.length == 1) {
                DpInterfaceImpl.addNotification(performanceEvent);
                return;
            }
            DpInterfaceImpl.LogMessage("POD:Throwing away multi-valued scalar performance event:\n" + performanceEvent.toString());
            return;
        }
        DpInterfaceImpl.LogMessage("Scalar handle called for Defintion with table values");
    }

    public boolean evaluate(Object object, Object[] objectArray, Object[] objectArray2, long l) {
        boolean bl = false;
        DpNode dpNode = (DpNode)object;
        if (dpNode.getNotifyObject().getWhenToNotify() == 5) {
            int n = 0;
            while (n < objectArray.length && !bl) {
                if (!objectArray[n].equals(objectArray2[n])) {
                    bl = true;
                }
                ++n;
            }
        } else if (dpNode.getPollingInstance().sendEvents() && dpNode.armStuff != null) {
            int n = dpNode.armStuff.getWhenToNotify();
            if (n == 1) {
                bl = true;
            } else if (n == 4) {
                if (dpNode.scalarPoller != null && dpNode.tablePoller != null) {
                    bl = false;
                } else if (dpNode.scalarPoller != null && dpNode.tablePoller == null) {
                    if (dpNode.expressionList != null && dpNode.expressionList.length == 1) {
                        float f = ((DataPoint)dpNode.getLatestEntry()).getValue();
                        bl = this.eval(dpNode, f);
                    } else {
                        Vector vector = ((MultiDataPoint)dpNode.getLatestEntry()).getValues();
                        float f = ((Float)vector.elementAt(0)).floatValue();
                        bl = this.eval(dpNode, f);
                    }
                } else {
                    DpInterfaceImpl.LogMessage("Scalar evaluate called for Defintion with table values");
                }
            }
        }
        return bl;
    }

    private boolean eval(DpNode dpNode, Object object) {
        return this.eval(dpNode, object, Float.NEGATIVE_INFINITY);
    }

    private boolean eval(DpNode dpNode, float f) {
        return this.eval(dpNode, null, f);
    }

    private boolean eval(DpNode dpNode, Object object, float f) {
        boolean bl = false;
        if (dpNode != null) {
            if (this.armStuff == null) {
                bl = false;
            } else if (this.armStuff.getWhenToNotify() == 1) {
                bl = true;
            } else if (this.armStuff.getWhenToNotify() == 2) {
                bl = false;
            } else if ("AUTO".equals(this.armStuff.getArmOp())) {
                bl = object != null ? dpNode.autoCheck(object) : dpNode.autoCheck();
                if (DpInterfaceImpl.trace_expression) {
                    DpInterfaceImpl.LogMessage("# " + this.definition.getIdentifier() + ":" + dpNode.getIpAddress() + "   Evaluation = " + bl);
                }
            } else {
                float f2;
                String string;
                if (!dpNode.getArmedState(object)) {
                    string = this.armStuff.getArmOp();
                    f2 = this.armStuff.getArmValue();
                } else {
                    string = this.armStuff.getRearmOp();
                    f2 = this.armStuff.getRearmValue();
                }
                bl = string.equals("==") ? f == f2 : (string.equals("!=") ? f != f2 : (string.equals(">=") ? f >= f2 : (string.equals("<=") ? f <= f2 : (string.equals("<") ? f < f2 : (string.equals(">") ? f > f2 : false)))));
                if (bl) {
                    dpNode.changeArmedState(object);
                    if (DpInterfaceImpl.trace_expression) {
                        DpInterfaceImpl.LogMessage(" ## " + this.definition.getIdentifier() + ":" + dpNode.getIpAddress() + "   Evaluation = true: " + f + string + f2);
                    }
                } else if (DpInterfaceImpl.trace_expression) {
                    DpInterfaceImpl.LogMessage(" ## " + this.definition.getIdentifier() + ":" + dpNode.getIpAddress() + "   Evaluation = false: " + f + string + f2);
                }
            }
        } else {
            DpInterfaceImpl.LogMessage("evaluate called without userData ");
        }
        return bl;
    }

    public void preHandle(Object object, Object[] objectArray, Object[] objectArray2, long l) {
        DpNode dpNode = (DpNode)object;
        if (dpNode.getNotifyObject().getWhenToNotify() == 5) {
            return;
        }
        if (dpNode != null) {
            if (dpNode.scalarPoller != null && dpNode.tablePoller == null) {
                Expression[] expressionArray;
                long l2;
                long l3;
                if (DpInterfaceImpl.useSysUpTime) {
                    l3 = ((TimeTicks)objectArray[dpNode.getSysUpTimeIndex()]).getValue();
                    l2 = objectArray2[0] != null ? ((TimeTicks)objectArray2[dpNode.getSysUpTimeIndex()]).getValue() : 0L;
                    l3 /= 100L;
                    l2 /= 100L;
                } else {
                    l2 = dpNode.getLatestEntry().getDate();
                    l3 = l;
                    l3 /= 1000L;
                    l2 /= 1000L;
                }
                if (l2 != 0L) {
                    long l4 = l3 - l2;
                    long l5 = dpNode.getNotifyObject().getPollingInterval();
                    if (l4 < l5 + 1L) {
                        DpInterfaceImpl.intervalMatched(dpNode);
                    } else {
                        DpInterfaceImpl.intervalExceeded(dpNode, l, l2, l5);
                    }
                }
                if ((expressionArray = this.expressionList) == null) {
                    expressionArray = dpNode.expressionList;
                }
                if (dpNode.getNotifyObject().getWhenToNotify() != 5) {
                    if (expressionArray.length == 1) {
                        dpNode.addToHistory(l, null, new Float(expressionArray[0].calculate(objectArray, objectArray2, l3, l2)));
                    } else {
                        Vector<Float> vector = new Vector<Float>();
                        int n = 0;
                        while (n < expressionArray.length) {
                            vector.addElement(new Float(expressionArray[n].calculate(objectArray, objectArray2, l3, l2)));
                            ++n;
                        }
                        dpNode.addToHistory(l, null, vector);
                    }
                    if (DpInterfaceImpl.trace) {
                        DpInterfaceImpl.LogMessage("Adding data");
                    }
                }
            } else {
                if (DpInterfaceImpl.trace) {
                    DpInterfaceImpl.LogMessage("Scalar prehandle called for Defintion with table values");
                }
                dpNode.saveScalarValues(objectArray2, objectArray);
            }
        } else {
            DpInterfaceImpl.LogMessage("preHandle called with no userData");
        }
        DpInterfaceImpl.interfaceObject.updateCounters(1, objectArray.length);
    }

    public void xhandle(Object object, Object[] objectArray, Object[] objectArray2, long l) {
    }

    public void xpreHandle(Object object, Object[] objectArray, Object[] objectArray2, long l) {
        DpNode dpNode = (DpNode)object;
        DpInterfaceImpl.LogMessage(dpNode.getFileName());
    }

    public boolean xevaluate(Object object, Object[] objectArray, Object[] objectArray2, long l) {
        return false;
    }

    public void xhandle(Object object, Vector vector, Vector vector2, Vector vector3, long l) {
    }

    public void xpreHandle(Object object, Vector vector, Vector vector2, Vector vector3, long l) {
        DpNode dpNode = (DpNode)object;
        DpInterfaceImpl.LogMessage(dpNode.getFileName());
    }

    public boolean xevaluate(Object object, Vector vector, Vector vector2, Vector vector3, long l) {
        return false;
    }
}

